<?php

namespace onespace\tutorial\migrations;

use yii\db\Migration;

/**
 * Class m000000_000001_initial_design_tables
 */
class m000000_000001_initial_design_tables extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable(
            '{{%tutorial}}',
            [
                'id' => $this->primaryKey(),
                'page_path' => $this->string(512)->notNull(),
                'update_version' => $this->string(128),
                'order' => $this->integer()->notNull(),
                'highlight_element' => $this->string(512),
                'title' => $this->string(512),
                'content' => $this->text()->notNull(),
                'side' => $this->string(25),
                'align' => $this->string(25)
            ]
        );

        $this->createTable(
            '{{%tutorial_user}}',
            [
                'id' => $this->primaryKey(),
                'user_id' => $this->string(50)->notNull(),
                'page_path' => $this->string(512)->notNull(),
                'update_version' => $this->string(128)
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable(
            '{{%tutorial}}'
        );

        $this->dropTable(
            '{{%tutorial_user}}'
        );
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m241125_121826_populate_feedback_types cannot be reverted.\n";

        return false;
    }
    */
}
