<?php
use onespace\tools\widgets\TinyMCE\TinyMCE;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

/**
 *
 * @var yii\web\View $this
 * @var onespace\tutorial\models\Tutorial $model
 * @var yii\widgets\ActiveForm $form
 */
?>

<div class="tutorial-form">

    <?php $form = ActiveForm::begin(
        [
            'id' => 'Tutorial',
            'layout' => 'horizontal',
            'enableClientValidation' => true,
            'errorSummaryCssClass' => 'error-summary alert alert-danger',
            'fieldConfig' => [
                'template' => "{label}\n{beginWrapper}\n{input}\n{hint}\n{error}\n{endWrapper}",
                'horizontalCssClasses' => [
                    'label' => 'col-sm-2',
                    // 'offset' => 'col-sm-offset-4',
                    'wrapper' => 'col-sm-8',
                    'error' => '',
                    'hint' => '',
                ],
            ],
        ]
    );
?>

    <div class="">

        <p>

            <!-- attribute page_path -->
            <?php echo $form->field($model, 'page_path')->textInput() ?>

            <!-- attribute update_version -->
            <!-- <?php echo $form->field($model, 'update_version')->textInput() ?> -->

            <!-- attribute order -->
            <?php echo $form->field($model, 'order')->textInput(['maxlength' => true, 'type' => 'number']) ?>

            <!-- attribute highlight_element -->
            <?php echo $form->field($model, 'highlight_element')->textInput(['maxlength' => true]) ?>

            <!-- attribute title -->
            <?php echo $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

            <!-- attribute content -->
            <?php echo $form->field($model, 'content')->widget(TinyMCE::class, []) ?>

            <!-- attribute side -->
            <?php echo $form->field($model, 'side')->dropDownList(['' => 'Automatic', 'top' => 'Top', 'right' => 'Right', 'bottom' => 'Bottom', 'left' => 'Left']) ?>

            <!-- attribute align -->
            <?php echo $form->field($model, 'align')->dropDownList(['' => 'Automatic', 'start' => 'Start', 'center' => 'Center', 'end' => 'End']) ?>
        </p>

        <hr />

        <?php echo $form->errorSummary($model); ?>

        <?php echo Html::submitButton(
            '<span class="glyphicon glyphicon-check"></span> ' . ($model->isNewRecord ? 'Create' : 'Save'),
            [
                'id' => 'save-' . $model->formName(),
                'class' => 'btn btn-success',
            ]
        );
?>

        <?php ActiveForm::end(); ?>

    </div>

</div>