<?php

namespace onespace\tutorial\models\query;

use Yii;

class TutorialUserQuery extends \yii\db\ActiveQuery
{
    public function forPageTutorial($pagePath = null)
    {
        if ($pagePath == null) {
            $pagePath = Yii::$app->controller->action->uniqueId;
        }
        $this->andWhere(['page_path' => $pagePath, 'update_version' => ['', null]]);
        return $this;
    }

    public function forUpdateTutorial($pagePath = null, $updateVersion = null) 
    {
        if ($pagePath == null) {
            $pagePath = Yii::$app->controller->action->uniqueId;
        }
        $this->andWhere(['page_path' => $pagePath, 'update_version' => $updateVersion]);
        return $this;
    }

    public function forUser($userId = null)
    {
        if ($userId == null) {
            $userId = Yii::$app->user->id;
        }
        $this->andWhere(['user_id' => strval($userId)]);
        return $this;
    }

    /**
     * @inheritdoc
     * @return \app\models\AccessPoint[]|array
     */
    public function all($db = null)
    {
        return parent::all($db);
    }

    /**
     * @inheritdoc
     * @return \app\models\AccessPoint|array|null
     */
    public function one($db = null)
    {
        return parent::one($db);
    }
}