<?php

namespace onespace\tutorial\controllers;

use onespace\tutorial\models\TutorialUser;
use Yii;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\web\Controller;

/**
 * Controller for predefined widget endpoints
 * @package onespace\tutorial\controllers
 */
class WidgetController extends Controller {
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'complete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['complete'],
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    
    public function actionComplete() {
        $pagePath = Yii::$app->request->post('pagePath');
        $updateVersion = Yii::$app->request->post('updateVersion');

        $modelQuery = TutorialUser::find()->forUser(Yii::$app->user->id);
        if ($updateVersion == null) {
            $modelQuery->forPageTutorial($pagePath);
        } else {
            $modelQuery->forUpdateTutorial($pagePath, $updateVersion);
        }

        // check if this user has done this before
        $model = TutorialUser::findOne(['user_id' => strval(Yii::$app->user->id), 'page_path' => $pagePath, 'update_version' => $updateVersion]);
        if ($model == null) {
            $model = new TutorialUser(['user_id' => strval(Yii::$app->user->id), 'page_path' => $pagePath, 'update_version' => $updateVersion]);
        }
        $success = $model->save();
        if (!$success) {
            Yii::warning('Errors: '.implode($model->getErrorSummary(true)), __METHOD__);
        }
        return $this->asJson(['success' => $success]);
    }
}