<?php

namespace onespace\tutorial\models\query;

use Yii;

class TutorialQuery extends \yii\db\ActiveQuery
{
    public function pageTutorial($pagePath = null)
    {
        if ($pagePath == null) {
            $pagePath = Yii::$app->controller->action->uniqueId;
        }
        $this->andWhere(['page_path' => $pagePath, 'update_version' => ['', null]])->orderBy(['order' => SORT_ASC]);
        return $this;
    }

    public function updateTutorial($pagePath = null, $updateVersion = null) 
    {
        if ($pagePath == null) {
            $pagePath = Yii::$app->controller->action->uniqueId;
        }
        $this->andWhere(['page_path' => $pagePath, 'update_version' => $updateVersion]);
        return $this;
    }

    public function inOrder() {
        $this->orderBy(['order' => SORT_ASC]);
        return $this;
    }

    /**
     * @inheritdoc
     * @return \app\models\AccessPoint[]|array
     */
    public function all($db = null)
    {
        return parent::all($db);
    }

    /**
     * @inheritdoc
     * @return \app\models\AccessPoint|array|null
     */
    public function one($db = null)
    {
        return parent::one($db);
    }
}