# Module Library Template

## Step 1 - Set Up `composer.json`

Open the `composer.json` file and replace all the values between chevrons (`<>`) with appropriate values:

- `<YOUR-LIBRARY-NAME>` - an appropriate name for the library, required for composer.
- `<BASIC DESCRIPTION>` - provide a basic description of the library
- `<NAMESPACE>` - This is the most important entry as every class which references this library, uses this namespace.
- `<NAME>` & `<EMAIL>` - For initial attribution, you can remove this section if you would prefer.

## Step 2 - Install Any Dependancies

```sh
composer require libraryOwner/package
```

_etc._

## Step 3 - Composer Update

Finally run a `composer update` to validate your package and to ensure namespace resolution happens as entended.

## Step 4 - Build Your Library

Finally build your library within the `src/` directory and add any tests / cests within the `tests/`

## See

- [Dev Wiki Documentation](https://dev-wiki.1s.co.za/books/developer-guide/page/creating-a-common-library-module)
