<?php
use yii\helpers\Html;

/**
 *
 * @var yii\web\View $this
 * @var onespace\tutorial\models\Tutorial $model
 */
$this->title = 'Tutorial';
$this->params['breadcrumbs'][] = ['label' => 'Tutorials', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => (string)($model->page_path . ' - ' . $model->order), 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Edit';
?>
<div class="giiant-crud tutorial-update">

    <h1>
        Tutorial
        <small>
            <?php echo Html::encode($model->page_path . ' - ' . $model->order) ?>
        </small>
    </h1>

    <div class="crud-navigation">
        <?php echo Html::a('<span class="glyphicon glyphicon-file"></span> ' . 'View', ['view', 'id' => $model->id], ['class' => 'btn btn-default']) ?>
    </div>

    <hr />

    <?php echo $this->render('_form', [
        'model' => $model
    ]); ?>

</div>
