<?php

namespace onespace\tutorial\models\search;

use onespace\tutorial\models\Tutorial as BaseModel;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * This is the model class for table "tutorial".
 *
 * @property int $id
 * @property string $page_path
 * @property string $update_version
 * @property int $order
 * @property string $highlight_element
 * @property string $title
 * @property string $content
 * @property string $side
 * @property string $align
 */
class Tutorial extends BaseModel
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'order'], 'integer'],
            [['page_path', 'highlight_element', 'title'], 'string', 'max' => 512],
            [['update_version'], 'string', 'max' => 128],
            [['side', 'align'], 'string', 'max' => 25],
            [['content'], 'string']
        ];
    }    
    
    /**
    * @inheritdoc
    */
   public function scenarios() {
       // bypass scenarios() implementation in the parent class
       return Model::scenarios();
   }

   /**
    * Creates data provider instance with search query applied
    *
    * @param array $params
    *
    * @return ActiveDataProvider
    */
   public function search($params) {
       $query = BaseModel::find();

       // add conditions that should always apply here

       $dataProvider = new ActiveDataProvider([
           'query' => $query,
       ]);

       $this->load($params);

       if (!$this->validate()) {
           // uncomment the following line if you do not want to return any records when validation fails
           // $query->where('0=1');
           return $dataProvider;
       }

       // grid filtering conditions
       $query->andFilterWhere([
           'id' => $this->id,
           'order' => $this->order,
           'side' => $this->side,
           'align' => $this->align,
       ]);

       $query->andFilterWhere(['like', 'page_path', $this->page_path])
           ->andFilterWhere(['like', 'highlight_element', $this->highlight_element])
           ->andFilterWhere(['like', 'title', $this->title])
           ->andFilterWhere(['like', 'content', $this->content]);

       return $dataProvider;
   }
}

