<?php

namespace onespace\inertia\components;

use Exception;
use Yii;
use yii\base\Component;
use yii\rbac\ManagerInterface;
use yii\rbac\Role;

/**
 * Some basic User assistant tooling for working with Inertia.
 * 
 * @author Gareth Palmer <gareth@one-space.co.za>
 */
class User extends Component {
    /**
     * Return a list of user roles from the RBAC lists.
     * 
     * @return string[]
     */
    public static function userRoles(): array {
        $allRoles = [];
        try {
            $authManager = Yii::$app->authManager;
            if ($authManager === null) {
                throw new Exception("RBAC not implimented in this project");
            }

            $roles = $authManager->getRolesByUser(Yii::$app->user->id);

            foreach ($roles as $role) {
                self::addRoleWithChildren($role, $allRoles, $authManager);
            }
        } catch (\Throwable $th) {
            Yii::error($th->getMessage(), __METHOD__);
        }
        return array_values(array_unique($allRoles));
    }

    /**
     * NOT YET IMPLIMENTED
     * 
     * @return string[]
     */
    public static function userPermissions(): array {
        return [];
    }

    /**
     * Recursively add children to the flat list of roles.
     * 
     * @param Role $role
     * @param string[] &$allRoles
     * @param ManagerInterface $authManager
     */
    private static function addRoleWithChildren(Role $role, array &$allRoles, ManagerInterface $authManager): void {
        $allRoles[] = $role->name;
        $children = $authManager->getChildren($role->name);

        foreach ($children as $child) {
            if ($child instanceof Role) {
                self::addRoleWithChildren($child, $allRoles, $authManager);
            }
        }
    }
}
