<?php

namespace onespace\inertia\helpers;

enum Style {
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_SUCCESS;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_INFO;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_WARN;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_ERROR;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_SECONDARY;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_CONTRAST;

    public function id(): string {
        return match ($this) {
            self::PRIME_SUCCESS   => 'success',
            self::PRIME_INFO      => 'info',
            self::PRIME_WARN      => 'warn',
            self::PRIME_ERROR     => 'error',
            self::PRIME_SECONDARY => 'secondary',
            self::PRIME_CONTRAST  => 'contrast',
        };
    }
}
