export interface commonPageProps {
    user: userProps | null;
    params: paramsProps | null;
    title: string;
}

export interface userIdentityProps {
  auth_tf_enabled: number | null;
  auth_tf_key: string | null;
  auth_tf_mobile_phone: string | null;
  auth_tf_type: string | null;
  blocked_at: number | null;
  confirmed_at: number | null;
  created_at: number;
  dynamics_guid: string | null;
  email: string | null;
  flags: number;
  gdpr_consent: number;
  gdpr_consent_date: string | null;
  gdpr_deleted: number;
  id: number;
  last_login_at: number | null;
  last_login_ip: string | null;
  number: string | null;
  password_changed_at: number;
  registration_ip: string | null;
  unconfirmed_email: string | null;
  updated_at: number;
  username: string;
}

export interface userProfileProps {
  bio: string | null;
  face_url: string | null;
  first_name: string | null;
  gravatar_email: string | null;
  gravatar_id: string | null;
  location: string | null;
  name: string | null;
  phone_number: string | null;
  public_email: string | null;
  surname: string | null;
  timezone: string | null;
  user_id: number;
  website: string | null;
}

export interface userProps {
  identity: userIdentityProps;
  profile: userProfileProps;
}

export interface auditEnabledParamsProps {
  entries: boolean;
  errors: boolean;
  logs: boolean;
  mails: boolean;
  trails: boolean;
}

export interface inertiaParamsProps {
  hotReload: boolean;
  main: string;
  port: number;
}

export interface serviceUrlsParamsProps {
  bindex: string;
  contractApi: string;
  incident: string;
  panic: string;
  property: string;
  serviceApi: string;
  urlShortener: string;
  userApi: string;
  userUi: string;
}

export interface paramsProps {
  adminEmail: string;
  auditEnabled: auditEnabledParamsProps;
  betaLogo: boolean;
  companyAddress: string;
  companyMarketingSite: string;
  companyName: string;
  companySalesEmail: string;
  companySalesPhone: string;
  companyShortName: string;
  context: string;
  favicon: string;
  iconPrefix: string;
  incidentBasePath: string;
  includeAccessControl: boolean;
  inertia: inertiaParamsProps;
  legacyPinIntegration: boolean;
  name: string;
  senderEmail: string;
  senderName: string;
  serviceUrls: serviceUrlsParamsProps;
  showUiMigrationMessage: boolean;
  skin: string;
  supportEmail: string;
  "user.passwordMinLength": number;
  "user.passwordResetTokenExpire": number;
}
