<?php

namespace onespace\inertia\components\base;

use onespace\inertia\helpers\Style;

abstract class BaseFeedbackComponent extends \yii\base\Component implements FeedbackInterface {
    /**
     * {@inheritdoc}
     */
    public function init() {
        parent::init();
        $this->ensureSessionVar();
    }

    /**
     * Ensure that the session id is set within `$_SESSION`
     *
     * @access  protected
     */
    public function ensureSessionVar(): void {
        $_SESSION[$this->sessionParam()] ??= [];
    }

    /**
     * Add an entry to $_SESSION.
     *
     * @param   array   $data   The data to add to sessions.
     *
     * @access  protected
     */
    protected function addToSession(array $data): void {
        $_SESSION[$this->sessionParam()][] = $data;
    }

    /**
     * Add a toast value to the list.
     *
     * @access  public
     */
    public function add(
        Style $key,
        ?string $header = null,
        mixed $value = null,
        bool $autoClose = false,
        int $closeDelay = 3000,
        bool $removeAfterAccess = true
    ): void {
        $this->addToSession([
            'type' => $key->id(),
            'time' => time(),
            'header' => $header,
            'value' => $value,
            'autoClose' => $autoClose,
            'closeDelay' => $closeDelay,
            'removeAfterAccess' => $removeAfterAccess,
        ]);
    }

    /**
     * Return the complete list of messages. If a toast has the `removeAfterAccess` flag
     * set to true, these messages will be removed.
     *
     * @return  array
     *
     * @access  public
     */
    public function getAllMessages(): array {
        $sessionList = $_SESSION[$this->sessionParam()];

        $toastList = [];
        foreach ($sessionList as $i => $toast) {
            $toastList[] = $toast;
            if ($toast['removeAfterAccess']) {
                unset($sessionList[$i]);
            }
        }
        $_SESSION[$this->sessionParam()] = array_values($sessionList);
        return $toastList;
    }
}
