<?php

namespace onespace\inertia\assets;

use yii\web\AssetBundle;
use yii\web\View;
use Yii;

/**
 * Main backend application asset bundle.
 */
class InertiaAsset extends AssetBundle {

    /**
     * The base http link when hot reloading.
     */

    public string $hotReloadLink = 'http://localhost';


    /**
     * {@inheritdoc}
     */

    public function init() {
        parent::init();

        $hotReload = Yii::$app->params['inertia']['hotReload'] ?? false;


        if ($hotReload) {
            $port = Yii::$app->params['inertia']['port'] ?? 5173;
            $main = Yii::$app->params['inertia']['main'] ?? 'frontend/main.tsx';


            Yii::info("HOT RELOAD", __METHOD__);
            $this->js[] = ["{$this->hotReloadLink}:{$port}/@vite/client", 'position' => View::POS_HEAD, 'type' => "module", 'crossorigin' => true];
            $this->js[] = ["{$this->hotReloadLink}:{$port}/{$main}", 'position' => View::POS_HEAD, 'type' => "module", 'crossorigin' => true];
        } else {
            Yii::info("NO HOT RELOAD", __METHOD__);
            // JS
            $matchingFiles = glob($this->sourcePath . 'inertia/assets/main*.js');
            foreach ($matchingFiles as $file) {
                $this->js[] = ['inertia/assets/' . basename($file), 'position' => View::POS_HEAD, 'type' => "module", 'crossorigin' => true];
            }

            // CSS
            $matchingFiles = glob($this->sourcePath . 'inertia/assets/*.css');
            foreach ($matchingFiles as $file) {
                $this->css[] = 'inertia/assets/' . basename($file);
            }
        }
    }


    /**
     * {@inheritdoc}
     */

    public function registerAssetFiles($view) {
        if (Yii::$app->params['inertia']['hotReload'] ?? false) {
            $port = Yii::$app->params['inertia']['port'] ?? 5173;
            echo <<<HTML
            <script type="module">
                import RefreshRuntime from '{$this->hotReloadLink}:{$port}/@react-refresh'
                RefreshRuntime.injectIntoGlobalHook(window)
                window.\$RefreshReg$ = () => {}
                window.\$RefreshSig$ = () => (type) => type
                window.__vite_plugin_react_preamble_installed__ = true
            </script>
            HTML;
        }
        parent::registerAssetFiles($view);
    }
}
