import { fileURLToPath, URL } from "node:url";

import { defineConfig } from "vite";
import react from "@vitejs/plugin-react";
// import laravel from "laravel-vite-plugin";
// import tsconfigPaths from "vite-tsconfig-paths";

// https://vitejs.dev/config/
export default defineConfig({
  base: "",
  plugins: [
    react({
      include: "**/*.tsx",
    }),
    // laravel({
    //   input: "frontend/main.tsx",
    //   refresh: true,
    //   hotFile: "runtime/hot",
    // }),
    // tsconfigPaths(),
  ],
  build: {
    outDir: "web/inertia",
  },
  resolve: {
    alias: {
      "@": fileURLToPath(new URL("./src", import.meta.url)),
      "@os": "./src",
    },
  },
});
