export function isObjectOrArray(value: unknown): boolean {
  if (Array.isArray(value)) {
    return true;
  } else if (typeof value === "object" && value !== null) {
    return true;
  }
  return false;
}

export function timeAgo(unixTimestamp: number): string {
  const currentTime = Math.floor(Date.now() / 1000);
  const difference = currentTime - unixTimestamp;

  if (difference < 0) {
    return "in the future";
  }

  const seconds = difference;
  const minutes = Math.floor(difference / 60);
  const hours = Math.floor(difference / 3600);
  const days = Math.floor(difference / 86400);

  if (seconds < 60) {
    return `${seconds} sec${seconds !== 1 ? "s" : ""} ago`;
  } else if (minutes < 60) {
    return `${minutes} min${minutes !== 1 ? "s" : ""} ago`;
  } else if (hours < 24) {
    return `${hours} hour${hours !== 1 ? "s" : ""} ago`;
  } else {
    return `${days} day${days !== 1 ? "s" : ""} ago`;
  }
}
