import React from "react";
import { modelProps, TableCellValueType } from "../types/props";
import {
  AuditIconButon,
  DeleteIconButton,
  EditIconButton,
  ViewIconButton,
} from "../components/buttons/TableActionButtons";

export const RenderCell = (
  value: TableCellValueType,
  fallback: TableCellValueType,
  model: modelProps,
): React.ReactNode => {
  if (typeof value === "function") {
    value = value(model);
  }

  if (value === undefined) {
    value = fallback;
  }

  if (value === null || value === "") {
    return NotSetValue();
  }

  if (value === true) {
    return ValueTrue();
  } else if (value === false) {
    return ValueFalse();
  }

  return <>{value}</>;
};

export const StandardActionColumn = (id: string | number, baseUri: string) => {
  return (
    <>
      <AuditIconButon navId={id} baseUri={baseUri} />
      <ViewIconButton navId={id} baseUri={baseUri} />
      <EditIconButton navId={id} baseUri={baseUri} />
      <DeleteIconButton navId={id} baseUri={baseUri} />
    </>
  );
};

export const NotSetValue = () => <em className="text-danger">Not Set</em>;
export const ValueTrue = () => <span className="text-success">&#10003;</span>;
export const ValueFalse = () => <span className="text-danger">&#10008;</span>;
