import React, { SetStateAction } from "react";
import { EmbeddedLoading, EmbeddedTooltip } from "../../types/props";
import { Icon } from "../../types/icon";
import { FAIdentifier } from "../../types/fa-icons";

export interface OSStatPanelProps
  extends EmbeddedTooltip,
    EmbeddedLoading,
    React.HTMLAttributes<HTMLElement> {
  /* Large value to display */
  value: string | number | undefined;

  /* Image/icon to display */
  icon: OSStatPanelIconTypes;

  /* Additional info dot content (optional) */
  description?: React.ReactNode | string | undefined;

  onFilter?: (filtered: boolean) => void;

  filtered?: boolean;
  setFiltered?: React.Dispatch<SetStateAction<boolean>>;
}

type OSStatPanelIconTypes =
    | Icon
    | FAIdentifier
    | Omit<React.ReactNode, string>;