import { OSPanelProps } from "./props";

/**
 * Standardized `div` variant to allow easy styling of information areas across the system.
 * No other features as of yet.
 */
export function OSPanel({
    children,
    className,
    ...props }: OSPanelProps) {
    return <div className={["os-panel", className].join(" ")} {...props}>
        {children}
    </div>
};
