import { MutableRefObject } from "react";
import { OSButton } from "../button/OSButton";
import { Maximize } from "./Maximize";
import { OSButtonProps } from "../button/props";

interface Props extends Partial<OSButtonProps> {
    maximizeRef: MutableRefObject<Maximize | null>;
}

export function MaximizeButton({ maximizeRef, ...props } : Props) {
    return (<>
        <OSButton
            icon={{
                identifier: "arrow-up-right-and-arrow-down-left-from-center",
                colour: "var(--colour-cool-grey)",
            }}
            onClick={maximizeRef.current?.maximize}
            {...props}
        />
    </>)
}