import { Dialog, DialogProps } from "primereact/dialog";
import { classNames } from "primereact/utils";
import React, { useCallback, useImperativeHandle } from "react";
import { useExposableState } from "../../hooks";

interface Props extends Partial<DialogProps> {
    isMaximized?: boolean;
    setIsMaximized?: React.Dispatch<React.SetStateAction<boolean>>
}

export type Maximize = {
    maximize(): void;
    minimize(): void;
    isMaximized: boolean;
}

export const MaximizeArea = React.forwardRef<Maximize, Props>(({ className, children, onShow, onHide, ...props }, ref) => {

    const [isMaximized, setIsMaximized] = useExposableState<boolean>(false, props.isMaximized, props.setIsMaximized);


    const maximize = useCallback(() => {
        console.log("Testing");
        setIsMaximized(true);
        onShow?.();
    }, []);

    const minimize = useCallback(() => {
        setIsMaximized(false);
        onHide?.();
    }, []);
    useImperativeHandle(ref, () => ({
        maximize,
        minimize,
        isMaximized
    }))

    return (<>
        {isMaximized && <Dialog
            className={classNames("maximize", isMaximized && "maximized", className)}
            visible={isMaximized}
            blockScroll
            maximized
            draggable={false}
            modal
            children={children}
            onHide={minimize}
            {...props}
        />}
        {children}
    </>);
})