import React from "react";
import { InputMask, InputMaskProps } from "primereact/inputmask";
// import { InputText, InputTextProps } from "primereact/inputtext";
import { EntryField } from "../../utils/FormTool/Form";

interface PrimeInputMaskProps extends InputMaskProps {
  id: string;
  model?: EntryField | undefined;
  value?: string | null | undefined;
  label?: string | null | undefined;
  hint?: string | null | undefined;
  error?: string | null | undefined;
  required?: boolean | undefined;
}

/** @deprecated */
const PrimePhoneNumber: React.ForwardRefExoticComponent<
  PrimeInputMaskProps & React.RefAttributes<InputMask>
> = React.forwardRef(
  (
    { id, model, value, label, hint, error, required = false, ...props },
    ref,
  ) => {
    const placedValue = model?.value || value || "";
    const placedLabel = model?.label || label || null;
    const placedHint = model?.hint || hint || null;
    const placedError = model?.error || error || null;
    const placedRequired = model?.required || required || false;
    return (
      <div className="flex flex-col gap-2 mb-3">
        {placedLabel && (
          <label
            htmlFor={id}
            title={placedRequired === true ? "Required field" : undefined}
          >
            {placedLabel}
            {placedRequired === true ? (
              <>
                <span className="text-red-500 ml-2">*</span>
              </>
            ) : null}
          </label>
        )}
        <InputMask
          id={id}
          value={placedValue as string}
          {...props}
          ref={ref}
          invalid={placedError !== null}
          required={placedRequired}
          mask={props.mask ?? "(999) 9999 999"}
        />
        {placedHint && <small id={`${id}-help`}>{placedHint}</small>}
        {placedError && (
          <small id={`${id}-error`} className="text-red-500">
            {placedError}
          </small>
        )}
      </div>
    );
  },
);

export default PrimePhoneNumber;
