import { EntryField } from "../../utils/FormTool/Form";
import { Calendar, CalendarBaseProps } from "primereact/calendar";
import { FormEvent } from "primereact/ts-helpers";
import React from "react";

interface PrimeCalendarProps extends CalendarBaseProps {
  id: string;
  model?: EntryField | undefined;
  value?: Date | Date[] | (Date | null)[] | null | undefined;
  label?: string | null | undefined;
  hint?: string | null | undefined;
  error?: string | null | undefined;
  required?: boolean | undefined;
  onChange?(event: FormEvent<Date>): void;
}

/** @deprecated */
const PrimeCalendar: React.ForwardRefExoticComponent<
  PrimeCalendarProps & React.RefAttributes<Calendar>
> = React.forwardRef(
  (
    {
      id,
      model,
      value,
      label,
      hint,
      error,
      required = false,
      onChange,
      ...props
    },
    ref,
  ) => {
    const placedValue = model?.value || value || "";
    const placedLabel = model?.label || label || null;
    const placedHint = model?.hint || hint || null;
    const placedError = model?.error || error || null;
    const placedRequired = model?.required || required || false;
    return (
      <div className="flex flex-col gap-2 mb-3">
        {placedLabel && (
          <label
            htmlFor={id}
            title={placedRequired === true ? "Required field" : undefined}
          >
            {placedLabel}
            {placedRequired === true ? (
              <>
                <span className="text-red-500 ml-2">*</span>
              </>
            ) : null}
          </label>
        )}
        <Calendar
          id={id}
          value={placedValue as Date}
          {...props}
          ref={ref}
          invalid={placedError !== null}
          required={placedRequired}
          dateFormat={props.dateFormat ?? "yy-mm-dd"}
          showIcon={props.showIcon ?? true}
          onChange={onChange}
        />
        {placedHint && <small id={`${id}-help`}>{placedHint}</small>}
        {placedError && (
          <small id={`${id}-error`} className="text-red-500">
            {placedError}
          </small>
        )}
      </div>
    );
  },
);

export default PrimeCalendar;
