import { OSLabel } from "../label";
import { OSAvatar } from "../avatar";
import { OSInfoTileProps } from "./props";

export function OSInfoTile({ avatar, label, className, ...props }: OSInfoTileProps) {
    return (<>
        <div {...props} className={["flex", "gap-1", "items-center", className].join(" ")}>
            <OSAvatar {...avatar} size="small" />
            <OSLabel {...label} />
        </div>
    </>);
}