import { Icon } from "../../types/icon";
import { MenuItem } from "primereact/menuitem";
import { EmbeddedTooltip } from "../../types/props";
import React, { ReactElement } from "react";
import { OSInfoCard } from "./OSInfoCard";
import { OSLabelProps } from "../label";
import { OSAvatarProps } from "../avatar";
import { FAIdentifier } from "../../types/fa-icons";
import { OSChipProps } from "../chip/props";
import { OSIconProps } from "../icon";

/**
 * Primary properties for {@link OSInfoCard}
 */
export interface OSInfoCardProps
  extends EmbeddedTooltip,
    React.HTMLAttributes<HTMLElement> {
  /** Image-based avatar */
  image?: string;
  /** Fallback icon for avatar if no image */
  fallback: Icon | string;
  /** List of data items for displaying. Accepts any react node if necessary. */
  fields: (OSInfoCardItemProps | React.ReactNode)[];
  /** List of actions for drop down list */
  actions?: MenuItem[];
  /** Primary title/heading of info card */
  label: string | undefined;
  /** A React Element primary title/heading of info card */
  fancyLabel?: ReactElement | undefined;
  /** Primary title/heading's link */
  link?: string;
  /** Optional badge on avatar for additional type information */
  badge?: OSInfoCardBadgeProps;
  /** Optional heading subtitle */
  heading?: React.ReactNode | string;
  /** Optional information chips at bottom of card */
  chips?: Omit<OSChipProps, "loading">[];
  /** Global flag for toggling the skeleton view */
  loading?: boolean;

  /** Directly interface with embedded OSAvatar. */
  avatarOptions?: Partial<OSAvatarProps> | undefined;
  /** Directly interface with embedded OSLabels for fields. */
  fieldOptions?: Partial<OSLabelProps> | undefined;
  /** Directly interface with embedded OSLabel for label. */
  labelOptions?: Partial<OSLabelProps> | undefined;
}
/**
 * Properties for individual piece of information.
 *
 * Largely shared information with {@link OSLabelProps}, but `leadingIcon` is required.
 */
export interface OSInfoCardItemProps extends OSLabelProps {
  /**
   * Icon before label.
   * Affected by justification.
   */
  leadingIcon: Icon | FAIdentifier | undefined;

  /**
   * Include additional React nodes with this element. Usually used to include dialog actions with item.
   */
  additionalNodes?: React.ReactNode;
}

/**
 * Badge properties for {@link OSInfoCard}
 */
export interface OSInfoCardBadgeProps extends Omit<OSIconProps, "identifier"> {
  identifier?: FAIdentifier | undefined;
  image?: string | undefined;
  backgroundColour?: string | undefined;
}