import { Skeleton } from "primereact/skeleton";
import { OSLabel } from "../label";
import { OSInfoCardItemProps } from "./props";
import { resolveIcon } from "../../internal/helpers/resolveIcon";

/** Handle rendering of individual info item  */
export default function Field({
    loading,
    onClick,
    label,
    leadingIcon,
    additionalNodes,
    ...props
}: OSInfoCardItemProps & { loading?: boolean }) {
    let classes = ["flex", "os-info-card-field"];
    if (onClick) {
        classes.push("cursor-pointer");
    } else {
        classes.push("select-all");
    }

    leadingIcon = resolveIcon(leadingIcon)!;

    return (<>
        {label !== undefined && !loading
            ? <OSLabel {...props}
                onClick={onClick}
                className={classes.join(" ")}
                label={label}
                tag={"span"}
                leadingIcon={leadingIcon}
            />
            : <div className="flex flex-row gap-1">
                <Skeleton height="1.2rem" width="1.2rem" />
                <Skeleton height="1.2rem" width="80%" className="self-center" />
            </div>}
        {additionalNodes && additionalNodes}
    </>);
}