import { Skeleton } from "primereact/skeleton";
import { OSIcon } from "../icon/OSIcon";
import { OSInfoCardBadgeProps } from "./props";
import { useRef } from "react";
import { Tooltip } from "primereact/tooltip";

/** Handle rendering of badge */
export default function Badge({
  backgroundColour,
  loading,
  identifier,
  image,
  tooltip,
  tooltipOptions,
  className,
  style,
  ...props
}: OSInfoCardBadgeProps & { loading?: boolean }) {
  const elementRef = useRef<any>(null);

  const classes =
    "os-info-card-badge absolute bottom-0 left-0 grid align-items-center";
  return (
    <div style={{ fontSize: "1rem" }}>
      {loading ? (
        <div className={classes}>
          <Skeleton
            className="border-2 border-white"
            width="calc(1rem * 2)"
            shape="circle"
            height="calc(1rem * 2)"
          />
        </div>
      ) : (
        <div
          ref={elementRef}
          className={[
            "border-(--colour-corporate-blue) border-1",
            "h-[2em] w-[2em]",
            classes,
            className,
          ].join(" ")}
          style={{
            backgroundColor: backgroundColour ?? "white",
            overflow: "clip",
            ...style
          }}
        >
          {identifier && (
            <OSIcon
              {...props}
              identifier={identifier}
              className="place-self-center"
              size={"1em"}
            />
          )}
          {image && (
            <img
              className="place-self-center fa-fw"
              style={{ width: "1.1em" }}
              src={image}
            />
          )}
          {tooltip && elementRef !== null && (
            <Tooltip
              target={elementRef as React.RefObject<HTMLElement>}
              {...tooltipOptions}
            >
              {tooltip}
            </Tooltip>
          )}
        </div>
      )}
    </div>
  );
}
