import { OSIconProps } from "..";

export function ColourCircle(colour: string | undefined, opts?: Partial<OSIconProps>): OSIconProps {
    return {
        className: `colour-circle ${colour?.toLowerCase() ?? "unknown"}`,
        identifier: colour ? "circle" : "circle-dashed",
        colour: colour,
        tooltip: colour ?? "Color Unknown",
        weight: colour ? "solid" : undefined,
        ...opts
    }
}