import React, { PropsWithChildren, ReactNode } from "react";
import { OSExpander } from "./OSExpander";
import { OSLabelProps } from "../label";

/**
 * Properties for {@link OSExpander}.
 */
export interface OSExpanderProps
  extends PropsWithChildren,
    React.HTMLAttributes<HTMLElement> {
  /** Set initial state of open, or control open/closed state externally */
  open?: boolean;
  setOpen? : React.Dispatch<React.SetStateAction<boolean>>;

  label?: OSLabelProps;

  header: ReactNode;
}
