import React, { PropsWithChildren, ReactNode } from "react";
import { OSLabelProps } from "../label";
import { OSDivider } from "./OSDivider";

/**
 * Properties for {@link OSDivider}.
 */
export interface OSDividerProps
  extends PropsWithChildren,
    React.HTMLAttributes<HTMLElement> {
  /** Set initial state of open, or control open/closed state externally */
  open?: boolean;
  setOpen?: React.Dispatch<React.SetStateAction<boolean>>;
  /** Set label content  */
  label?: OSLabelProps | ReactNode;

  /** Area for custom components within divider line */
  actions?: React.ReactNode;
}
