import { DataTableStateEvent, DataTableFilterMeta } from "primereact/datatable";

export interface DataTableProviderConfig<TModel, TResponse> {
  initState?: Partial<DataTableState>;
  providerPath?: (response : TResponse) => Yii2DataProviderResponse<TModel>;
  additionalParams?: Record<string, any>;
}

export interface Yii2DataProviderResponse<TModel> {
  models: Record<string, TModel>[];
  totalCount: number;
  page: number;
  pageSize: number;
}

export interface DataTableProviderProps<TModel, TResponse> extends DataTableState {
  value: Record<string, TModel>[];
  rawData: TResponse | undefined;
  //Manually perform a search with current information.

  /**
   * Defines if data is loaded and interacted with in lazy manner.
   * @defaultValue true
   */
  lazy: true;

  paginator: true;

  /**
   * Number of total records, defaults to length of value when not defined.
   */
  totalRecords?: number | undefined;
  /**
   * Callback to invoke on pagination.
   * @param {DataTableStateEvent} event - Custom state event.
   */
  onPage(event: DataTableStateEvent): void;

  /**
   * Callback to invoke on sort.
   * @param {DataTableStateEvent} event - Custom state event.
   */
  onSort(event: DataTableStateEvent): void;

  /**
   * Callback to invoke on filtering.
   * @param {DataTableStateEvent} event - Custom state event.
   */
  onFilter(event: DataTableStateEvent): void;

  /**
   * Displays a loader to indicate data load is in progress.
   * @defaultValue false
   */
  loading?: boolean;
}

export interface DataTableState {
  page?: number;

  /**
   * Index of the first row to be displayed.
   * @defaultValue 0
   */
  first: number;
  /**
   * Number of rows to display per page.
   */
  rows: number;
  /**
   * Property of a row data used for sorting, defaults to field.
   */
  sortField?: string | undefined;
  /**
   * Order to sort the data by default.
   */
  sortOrder: 1 | 0 | -1 | null | undefined;

  /**
   * An array of FilterMetadata objects to provide external filters.
   */
  filters: DataTableFilterMeta | undefined;

  totalPages?: number | undefined;
}