import { ColumnFilterElementTemplateOptions } from "primereact/column";
import { InputText, InputTextProps } from "primereact/inputtext";
import { DependencyList, useCallback } from "react";

interface TextFilterConfig extends Partial<InputTextProps> {
    afterFilter?: (value: any) => void;
}

export function useTextFilter(config?: TextFilterConfig, deps?: DependencyList): ((options: ColumnFilterElementTemplateOptions) => React.ReactNode) {
    return useCallback((options: ColumnFilterElementTemplateOptions) => {
        return (<InputText
            value={options.value || ""}
            onChange={(e) => {
                options.filterApplyCallback(e.target.value);
                config?.afterFilter?.(e.target.value);
            }}
            placeholder={`Filter`}
            className="p-column-filter"
            {...config}
        />)
    }, deps ?? []);
}