import { CollapseProps } from "./props";

/**
 * Collapse component to seperate/hide sections of the user interface.
 */
export function Collapse({
    collapsed,
    layout = "vertical",
    children,
    duration = 0.5,
    ...props
}: CollapseProps) {
    return (<>
        <div data-open={collapsed} >
            <div style={{
                display: "grid",
                gridTemplateRows: layout === "vertical" && collapsed ? "0fr" : "1fr",
                gridTemplateColumns: layout === "horizontal" && collapsed ? "0fr" : "1fr",
                transitionDuration: `${duration}s`,
                transitionProperty: "grid-template"
            }}>
                <div style={{
                    overflow: "hidden",
                    minHeight: 0,
                    minWidth: 0,
                    transition: `visibility ${duration * 2}s`,
                    visibility: collapsed ? "hidden" : "visible",
                }}>
                    <div {...props} children={children} />
                </div>
            </div>
        </div>
    </>)
};