import { classNames } from "primereact/utils";
import { ChevronProps } from "./props";
import { OSCSSProperties } from "../../types/react";

export function Chevron({ toggled, colour, ...props }: ChevronProps) {
    const styles : OSCSSProperties = {
        ...props.style,
        color: colour || props.style?.color
    }

    return (<i {...props}
        data-chevron-toggled={toggled}
        style={styles}
        className={classNames(props.className, "os-icon", "fa-fw", "fa-chevron-right", "fa-classic", "os-chevron", "self-center")} />);
}