import { Button, ButtonProps } from "primereact/button";
import React from "react";

interface SaveButtonProps extends ButtonProps {
  buttonClicked: boolean;
  normalText?: string;
  clickedText?: string;
  spacing?: boolean;
}

export const SaveButton: React.FC<SaveButtonProps> = ({
  buttonClicked,
  normalText = "Save",
  clickedText = "Saving...",
  spacing = true,
  ...props
}) => (
  <>
    <Button
      severity="success"
      icon={
        buttonClicked
          ? "fa-solid fa-spinner-third fa-spin"
          : "fa-solid fa-cloud-check"
      }
      label={buttonClicked ? clickedText : normalText}
      disabled={buttonClicked}
      {...props}
    />
    {spacing ? <>&nbsp;</> : null}
  </>
);
