import { ButtonProps } from "primereact/button";
import { EmbeddedTooltip } from "../../types/props";
import { Icon } from "../../types/icon";
import { OSButton } from "./OSButton";
import { FAIdentifier } from "../../types/fa-icons";

/**
 * Configuration for {@link OSButton}
 * 
 * Extends from PrimeReacts {@link ButtonProps}, modifying how `onClick`, `icon` and `loadingIcon` are handled.
 * 
 */
export interface OSButtonProps extends EmbeddedTooltip, Omit<ButtonProps, "icon" | "loadingIcon" | "tooltip"> {
    /**
     * Primary icon for button.
     * @default none
     */
    icon?: Icon | FAIdentifier | undefined;
    /**
     * Primary text of label.
     */
    label?: string | undefined;

    /**
     * Bypasses built in loading state.
     * 
     * Terminology borrowed from C#'s RelayCommand
     */
    allowConcurrentExecutions?: boolean | undefined;

    /**
     * Optional custom text while button is in `loading` state.
     */
    loadingLabel?: string | undefined;
}