/**
 * Input types available in form.
 * Divider is a static divider used for organization purposes, will always be full length.
 * Hidden inputs allow you to specify a field with a value that the user cannot interact with but will be posted.
 */
export enum OSInputType {
  Text = "text",
  TextArea = "textArea",
  Number = "number",
  Date = "date",
  Dropdown = "dropdown",
  Divider = "divider",
  Hidden = "hidden",
  Switch = "switch",
  Toggle = "toggle",
  Checkbox = "checkbox",
  ListBox = "listbox",
  MultiSelect = "multiSelect",
  SelectButton = "selectButton",
  Custom = "custom",
}

/**
 * Size of inputs, makes use of grid and cols.
 */
export enum OSInputSize {
  Third = "third",
  Half = "half",
  Full = "full",
}
