import React from "react";
import { modelProps, TableComponentProps } from "../src/types/props";
import { Table } from "react-bootstrap";
import { RenderCell } from "../src/helpers/TablerHelpers";
import {
  DeleteIconButton,
  EditIconButton,
  ViewIconButton,
} from "../src/components/buttons/TableActionButtons";

interface AppProps extends TableComponentProps {
  models: modelProps[];
  baseUri: string;
  showActions?: boolean;
}

const GridView: React.FC<AppProps> = ({
  models,
  baseUri,
  showActions = true,
  columns = null,
}) => {
  if (models.length === 0) {
    return (
      <>
        <table className="table">
          <tbody>
            <tr>
              <td>No results found.</td>
            </tr>
          </tbody>
        </table>
      </>
    );
  }

  const fields = models[0].fields;
  const labels = models[0].labels;

  return (
    <>
      <Table striped hover>
        <thead>
          <tr>
            {columns === null
              ? Object.keys(fields).map((key) => (
                  <th key={key}>{labels[key] ?? key}</th>
                ))
              : Object.keys(columns).map((key) => (
                  <th key={key}>
                    {columns[key]["label"] ?? labels[key] ?? key}
                  </th>
                ))}

            {showActions ? <th>Actions</th> : null}
          </tr>
        </thead>
        <tbody>
          {models.map((model, i) => {
            const fields = model.fields;
            return (
              <tr key={i}>
                {columns === null
                  ? Object.values(fields).map((field, k) => (
                      <td key={k}>{field}</td>
                    ))
                  : Object.keys(columns).map((key) => (
                      <td key={key}>
                        {RenderCell(
                          columns[key]["value"],
                          fields[key],
                          models[i],
                        )}
                      </td>
                    ))}

                {showActions ? (
                  <td>
                    <ViewIconButton navId={fields.id} baseUri={baseUri} />
                    <EditIconButton navId={fields.id} baseUri={baseUri} />
                    <DeleteIconButton navId={fields.id} baseUri={baseUri} />
                  </td>
                ) : null}
              </tr>
            );
          })}
        </tbody>
      </Table>
    </>
  );
};

export default GridView;
