import React, { ReactElement, useEffect, useState } from "react";
import { Link } from "@inertiajs/react";
import { Button } from "react-bootstrap";
import { BootstrapButtonSizes, BootstrapStyles } from "../src/types/enums";

interface SubmitButtonProps {
  text?: string;
  animate?: boolean;
  animateText?: string;
  loadingState?: boolean;
  // disabled?: boolean;
  formId?: string | undefined;
}

/**
 * @deprecated
 */
export const SubmitButton: React.FC<SubmitButtonProps> = ({
  text = "Save",
  animate = true,
  animateText = "Saving",
  loadingState = false,
  // disabled = false,
  formId = undefined,
}) => {
  const [isClicked, setIsClicked] = useState(loadingState);

  useEffect(() => {
    if (!animate) {
      return;
    }
    setIsClicked(loadingState);
  }, [loadingState, isClicked, animate]);

  return (
    <>
      <Button
        variant="primary"
        type="submit"
        form={formId}
        // disabled={disabled || isClicked}
      >
        {isClicked ? (
          <>
            <i className="fa-solid fa-spinner-third fa-spin"></i>&nbsp;
            {animateText}
          </>
        ) : (
          <>
            <i className="fa-solid fa-cloud-check"></i>&nbsp;{text}
          </>
        )}
      </Button>
      &nbsp;
    </>
  );
};

interface BaseNavButtonProps {
  href: string;
  className?: string;
  variant?: BootstrapStyles;
  size?: BootstrapButtonSizes;
  disabled?: boolean;
}

interface NavButtonProps extends BaseNavButtonProps {
  text: string | ReactElement;
}

/**
 * @deprecated
 */
export const NavButton: React.FC<NavButtonProps> = ({
  text,
  href,
  className,
  variant = BootstrapStyles.SECONDARY,
  size = BootstrapButtonSizes.STANDARD,
  disabled = false,
}) => {
  const stdClass = `btn btn-${variant}`;
  if (className === undefined) {
    className = "";
  }
  if (disabled) {
    className = [className, "disabled"].filter(Boolean).join(" ");
  }
  const btnClass = [stdClass, size, className].filter(Boolean).join(" ");
  return (
    <>
      <Link
        href={href}
        className={btnClass}
        disabled={disabled}
        aria-disabled={disabled ? "true" : undefined}
      >
        {text}
      </Link>
      &nbsp;
    </>
  );
};

/**
 * @deprecated
 */
export const BackButton: React.FC<BaseNavButtonProps> = ({
  href,
  className,
  variant = BootstrapStyles.SECONDARY,
  size = BootstrapButtonSizes.STANDARD,
  disabled = false,
}) => (
  <NavButton
    href={href}
    text="Back"
    className={className}
    variant={variant}
    size={size}
    disabled={disabled}
  />
);

/**
 * @deprecated
 */
export const CancelButton: React.FC<BaseNavButtonProps> = ({
  href,
  className,
  variant = BootstrapStyles.SECONDARY,
  size = BootstrapButtonSizes.STANDARD,
  disabled = false,
}) => (
  <NavButton
    href={href}
    text="Cancel"
    className={className}
    variant={variant}
    size={size}
    disabled={disabled}
  />
);

/**
 * @deprecated
 */
export const CreateButton: React.FC<BaseNavButtonProps> = ({
  href,
  className,
  variant = BootstrapStyles.PRIMARY,
  size = BootstrapButtonSizes.STANDARD,
  disabled = false,
}) => (
  <NavButton
    href={href}
    text={
      <>
        <i className="fa-solid fa-plus"></i>&nbsp;Create
      </>
    }
    className={className}
    variant={variant}
    size={size}
    disabled={disabled}
  />
);
