/**
 * Returns a string with the first character of string capitalized, if that character is an ASCII character in the range from "a" (0x61) to "z" (0x7a).
 * @param text The input string.
 * @returns Returns the resulting string.
 */
export const ucFirst = (text: string): string => {
  return text.charAt(0).toUpperCase() + text.slice(1);
};

/**
 * Returns a string with the first character of string lowercased if that character is an ASCII character in the range "A" (0x41) to "Z" (0x5a).
 * @param text The input string.
 * @returns Returns the resulting string.
 */
export const lcFirst = (text: string): string => {
  return text.charAt(0).toLowerCase() + text.slice(1);
};
