/**
 * Extends React's CSS Properties to allow custom properties
 *
 * In theory module augmentation should be used, but it is not playing nicely
 * https://github.com/frenic/csstype#what-should-i-do-when-i-get-type-errors+
 *
 */
export interface OSCSSProperties extends React.CSSProperties {
  [key: `--${string}`]: string | number | undefined;
}


/** Make certain fields of interface required, and the rest as required as they normally are. */
type Require<T, K extends keyof T> = Omit<T, K> & Required<Pick<T, K>>;