/**
 * Converts TS Date into y-m-d string
 * @param date Date object
 * @returns string e.g. 2025-02-10
 */
export const normalizeDate = (date: Date): string => {
  const localDate = new Date(date);
  localDate.setHours(0, 0, 0, 0);
  const year = localDate.getFullYear();
  const month = String(localDate.getMonth() + 1).padStart(2, "0");
  const day = String(localDate.getDate()).padStart(2, "0");
  return `${year}-${month}-${day}`;
};
