import React from "react";
import { EmbeddedLoading, EmbeddedTooltip } from "../../types/props";
import { Icon } from "../../types/icon";
import { FAIdentifier } from "../../types/fa-icons";

export interface OSStatPanelProps
  extends EmbeddedTooltip,
    EmbeddedLoading,
    React.HTMLAttributes<HTMLElement> {
  /* Large value to display */
  value: string | number | undefined;

  /* Image/icon to display */
  icon: OSStatPanelIconTypes;

  /* Additional info dot content (optional) */
  description?: React.ReactNode | string | undefined;
}

type OSStatPanelIconTypes =
    | Icon
    | FAIdentifier
    | Omit<React.ReactNode, string>;