import { OSStatPanelProps } from "./props";
import { OSPanel } from "../panel";
import { useRef } from "react";
import React from "react";
import { OSIcon } from "../icon";
import { Icon } from "../../types/icon";
import { OSLabel } from "../label";
import { Skeleton } from "primereact/skeleton";
import { Tooltip } from "primereact/tooltip";
import { FAIdentifier } from "../../types/fa-icons";

export function OSStatPanel({
    value,
    icon,
    description,
    tooltip,
    tooltipOptions,
    loading,
    ...props }: OSStatPanelProps) {

    const elementRef = useRef<any>(null);

    if (typeof icon === "string") {
        icon = { identifier: icon as FAIdentifier }
    }

    return (<>
        <OSPanel {...props}
            className={["place-content-center", "px-0", "py-4", "os-stat-panel", props.className].join(" ")}
            style={{
                containerType: "inline-size"
            }}>
            <div ref={elementRef}
                className="flex flex-col w-full gap-2 h-full place-content-center place-items-center" >
                {/* Icon */}
                <div className="flex">
                    {React.isValidElement(icon)
                        ? <div style={{ width: "var(--size-icon)", height: "var(--size-icon)" }}>{icon}</div>
                        : <OSIcon weight="thin" {...icon as Icon} size={"var(--size-icon)"} style={{ height: "var(--size-icon)" }} />}
                    {description && <div className="relative">
                        {/* Description badge */}
                        <div className="absolute">
                            <OSIcon
                                identifier="circle-info"
                                weight="solid"
                                size={"1rem"}
                                colour="var(--os-accent)"
                                tooltip={description}
                            />
                        </div>
                    </div>}
                </div>
                {/* Value */}
                {loading ? (
                    <div className="px-2 w-full">
                        <Skeleton height={"var(--size-value)"} />
                    </div>
                ) : (
                    <div className="flex place-content-center">
                        <OSLabel label={typeof value === "number"
                            ? new Intl.NumberFormat("en-ZA").format(value ?? 0)
                            : value}
                            colour="var(--colour-corporate-blue)"
                            size={"var(--size-value)"}
                            style={{ lineHeight: 1, userSelect: "none" }}
                            weight={200}
                        />
                    </div>
                )}
            </div>
        </OSPanel>
        {tooltip && (elementRef !== null) && <Tooltip target={elementRef as React.RefObject<HTMLElement>} mouseTrack {...tooltipOptions}>{tooltip}</Tooltip>}
    </>);
}