import { Icon } from "../../types/icon";
import { EmbeddedTooltip } from "../../types/props";
import { Property } from "csstype";
import { OSLabel } from "./OSLabel";
import { FontWeight } from "../../types/tailwind";
import React, { ReactElement } from "react";
import { FAIdentifier } from "../../types/fa-icons";

/**
 * Properties for {@link OSLabel}.
 *
 * Additional properties passed to child \<span/> or \<a/> element, depending if link is defined.
 */
export interface OSLabelProps
  extends EmbeddedTooltip,
    React.HTMLAttributes<HTMLElement> {
  /** Main text value of label */
  label: ReactElement | string | undefined;
  /**
   * Icon before label.
   *
   * Also accepts simply the icon identifier.
   *
   * Affected by justification.
   */
  leadingIcon?: Icon | FAIdentifier | false | undefined;
  /**
   * Icon after label.
   *
   * Also accepts simply the icon identifier
   *
   * Affected by justification.
   */
  trailingIcon?: Icon | FAIdentifier | false | undefined;
  /**
   * Justification of text/icons.
   * @default "left"
   */
  justify?: "left" | "right" | undefined;
  /**
   * Whether label should be rendered inline with other elements.
   * @default false
   */
  inline?: boolean | undefined;
  /**
   * Optional URL for label, to allow navigation.
   */
  link?: string | undefined;
  /**
   * Optional param to set target.
   */
  linkTarget?: string;
  /**
   * Colour of label and (by default) icons.
   * @default var(--colour-corporate-blue)
   */
  colour?: string | undefined;
  /**
   * Weighting of font.
   * @default "medium"
   */
  weight?: FontWeight | number | undefined;

  /**
   * Sizing of label and (by default) icons.
   * @default 1.5rem
   */
  size?: Property.FontSize<string | number> | undefined;

  /**
   * Should text be truncated?
   * @default true
   */
  truncate?: boolean | undefined;

  /**
   * Underlying HTML element.
   * Can be either tag identifier directly ("h3") or an object with `type` defining tag and additional tag-specific properties.
   * @default "div"
   */ 
  tag?: React.ElementType | TagProperties;
  
}

//Handle partial tag types
type TagPropertiesType<T extends keyof JSX.IntrinsicElements> ={
    type: T;
} & Partial<JSX.IntrinsicElements>[T];
type TagProperties = {[K in keyof JSX.IntrinsicElements]: TagPropertiesType<K>}[keyof JSX.IntrinsicElements]