import React from "react";
import { EntryField } from "../../utils/FormTool/Form";
import { InputSwitch, InputSwitchProps } from "primereact/inputswitch";

interface PrimeInputSwitch extends Omit<InputSwitchProps, "checked"> {
  id: string;
  isChecked?: boolean | undefined;
  model?: EntryField | undefined;
  label?: string | null | undefined;
  hint?: string | null | undefined;
  error?: string | null | undefined;
  required?: boolean | undefined;
}

/** @deprecated */
const PrimeInputSwitch: React.ForwardRefExoticComponent<
  PrimeInputSwitch & React.RefAttributes<InputSwitch>
> = React.forwardRef(
  (
    { id, model, isChecked, label, hint, error, required = false, ...props },
    ref,
  ) => {
    const placedValue = model?.value || isChecked || false;
    const placedLabel = model?.label || label || null;
    const placedHint = model?.hint || hint || null;
    const placedError = model?.error || error || null;
    const placedRequired = model?.required || required || false;
    return (
      <div className="flex flex-col gap-2 mb-3">
        {placedLabel && (
          <label
            htmlFor={id}
            title={placedRequired === true ? "Required field" : undefined}
          >
            {placedLabel}
            {placedRequired === true ? (
              <>
                <span className="text-red-500 ml-2">*</span>
              </>
            ) : null}
          </label>
        )}
        <InputSwitch
          id={id}
          {...props}
          checked={placedValue as boolean}
          ref={ref}
          invalid={placedError !== null}
          required={placedRequired}
        />
        {placedHint && <small id={`${id}-help`}>{placedHint}</small>}
        {placedError && (
          <small id={`${id}-error`} className="text-red-500">
            {placedError}
          </small>
        )}
      </div>
    );
  },
);

export default PrimeInputSwitch;
