import { OSIcon } from "./OSIcon";
import { OSIconStatefulProps } from "./props";

/**
 * Extension of {@link OSIcon} that allows for multiple icon configurations.
 * 
 * Can configure icons on a per-icon basis, or as a global option.
 * 
 * @example 
 * <OSStatefulIcon fallback="person" colour="green" size={"3rem"} states={[
 *    {
 *      state: "ready",
 *      icon: {
 *        identifier: "check",
 *      }
 *    },
 *    {
 *      state: "loading",
 *      icon: {
 *        identifier: "spinner",
 *        animation: "spin-pulse",
 *      }
 *    }
 *  ]}
 *    currentState={iconState} />
 * @returns 
 */
export function OSIconStateful<T extends string | number>({
    states,
    currentState,
    identifier,
    opacity,
    ...props
}: OSIconStatefulProps<T>) {
    const state = states.find(x => x.state === currentState);

    if (state) {
        //Hide if specified to (icon is null)
        if(state.icon === false || state.icon === null) {
            opacity = 0;
        }

        //Hide if intentionally using fallback but fallback isn't defined.
        if(state.icon === undefined && !identifier) {
            
        }
    } else {
        //Hide if needs fallback but none defined.
        if(!identifier) {
            opacity = 0;
        }
    }

    return <OSIcon identifier={identifier ?? "circle"} {...props} {...state?.icon} opacity={state || identifier ? opacity : 0} />;
}