import React, { ReactNode } from "react";
import { Link, usePage } from "@inertiajs/react";
import { userProps } from "../../types/props";

interface BaseIconButtonsProp {
  navId: string | number | ReactNode;
  baseUri: string;
}

export const ViewIconButton: React.FC<BaseIconButtonsProp> = ({
  navId,
  baseUri,
}) => (
  <>
    <Link href={`${baseUri}/view?id=${navId}`}>
      <i className="fa-solid fa-eye"></i>
    </Link>
    &nbsp;
  </>
);

export const EditIconButton: React.FC<BaseIconButtonsProp> = ({
  navId,
  baseUri,
}) => (
  <>
    <Link href={`${baseUri}/update?id=${navId}`}>
      <i className="fa-solid fa-pencil"></i>
    </Link>
    &nbsp;
  </>
);

interface DeleteIconButtonProp extends BaseIconButtonsProp {
  confirmMessage?: string;
}

export const DeleteIconButton: React.FC<DeleteIconButtonProp> = ({
  navId,
  baseUri,
  confirmMessage,
}) => {
  if (confirmMessage === undefined) {
    confirmMessage = "Are you sure?";
  }
  const handleClick = (e: React.MouseEvent<Element>) => {
    if (!window.confirm(confirmMessage)) {
      e.preventDefault();
    }
  };
  return (
    <>
      <Link href={`${baseUri}/delete?id=${navId}`} onClick={handleClick}>
        <i className="fa-solid fa-trash-can"></i>
      </Link>
      &nbsp;
    </>
  );
};

export const AuditIconButon: React.FC<BaseIconButtonsProp> = ({
  navId,
  baseUri,
}) => {
  const page = usePage();
  const userDetails = page.props.user as userProps;
  return (
    <>
      {userDetails.roles.includes("view-audit") ? (
        <>
          <Link href={`${baseUri}/change-log?id=${navId}`}>
            <i className="fa-solid fa-rectangle-history" />
          </Link>
          &nbsp;
        </>
      ) : null}
    </>
  );
};
