import React from "react";
import { Icon } from "../../types/icon";
import { EmbeddedTooltip } from "../../types/props";
import { OSAvatar } from "./OSAvatar";

/**
 * Configuration for {@link OSAvatar}.
 * 
 * Additional properties passed to child `<div/>` element.
 */
export interface OSAvatarProps
  extends EmbeddedTooltip,
    React.HTMLAttributes<HTMLElement> {
  /** Sizing of image */
  size: Size | string;
  /** Fallback image or node */
  fallback: Icon | React.ReactNode;
  /** URL of image to display */
  image?: string | undefined;
  /** Alternate image text in case of failure to load */
  alt?: string | undefined;
  /** Label for dialog */
  label?: string | undefined;

  /** Items in front of image */
  foreground?: React.ReactNode;

  /** Whether popup shows on click */
  zoomable?: boolean;
}

/** Commonly used sizes of OSAvatar */
type Size =
  | "small" //4rem
  | "large"; //11rem
