import { isObjectOrArray, timeAgo } from "../helpers/messageHelper";
import { BootstrapStyles } from "../types/enums";
import { messagesProp } from "../types/props";
import React, { useState } from "react";
import { Toast } from "react-bootstrap";

interface ToastProps {
  toast: messagesProp;
}

const ToastMessage: React.FC<ToastProps> = ({ toast }) => {
  const header = toast.header === null ? "Alert" : toast.header;

  const body = isObjectOrArray(toast.value)
    ? JSON.stringify(toast.value)
    : toast.value;

  const toastClass = ["mb-3"];
  if (toast.type !== BootstrapStyles.LINK) {
    toastClass.push(`toast-${toast.type}`);
  }

  const [show, setShow] = useState(true);

  return (
    <>
      {toast.autoClose ? (
        <Toast
          className={toastClass.join(" ")}
          onClose={() => setShow(false)}
          show={show}
          delay={toast.closeDelay}
          autohide
        >
          <Toast.Header>
            <i className="fa-regular fa-circle"></i>&nbsp;
            <strong className="me-auto">{header}</strong>
            <small>{timeAgo(toast.time)}</small>
          </Toast.Header>
          {body !== null ? <Toast.Body>{body as string}</Toast.Body> : null}
        </Toast>
      ) : (
        <Toast
          className={toastClass.join(" ")}
          onClose={() => setShow(false)}
          show={show}
        >
          <Toast.Header>
            <i className="fa-regular fa-circle"></i>&nbsp;
            <strong className="me-auto">{header}</strong>
            <small>{timeAgo(toast.time)}</small>
          </Toast.Header>
          {body !== null ? <Toast.Body>{body as string}</Toast.Body> : null}
        </Toast>
      )}
    </>
  );
};

export default ToastMessage;
