import { FAIdentifier, FontSize, FAAnimate } from "../../types/fa-icons";
import React, { CSSProperties } from "react";
import FAIcon from "../FAIcon";
import { OSLabel as UpdatedLabel } from "../label";

/** 
 * @deprecated 2025-07-03 - use {@link UpdatedLabel|OSLabel} instead.
 */
export interface OSLabelProps {
  label: string;
  link?: string;
  labelFontSize?: string;
  labelWeight?: number;
  labelColor?: string;
  justify?: "left" | "right";
  primaryIcon?: FAIdentifier;
  primaryIconSize?: FontSize;
  primaryIconColor?: string;
  primaryIconTitle?: string;
  primaryIconStyle?: CSSProperties;
  animatePrimaryIcon?: FAAnimate;
  secondaryIcon?: FAIdentifier;
  secondaryIconSize?: FontSize;
  secondaryIconColor?: string;
  secondaryIconTitle?: string;
  secondaryIconStyle?: CSSProperties;
  secondaryIconLink?: string;
  animateSecondaryIcon?: FAAnimate;
  width?: string;
  style?: CSSProperties;
  wrap?: boolean;
  onClick?: () => void;
}

/** 
 * @deprecated 2025-07-03 - use {@link UpdatedLabel|OSLabel} instead.
 */
const OSLabel: React.FC<{ props: OSLabelProps }> = ({ props }) => {
  const rightJustify = props.justify === "right";
  const labelStyle = {
    fontStyle: "Poppins",
    fontSize: props.labelFontSize ?? "1.5rem",
    color: props.labelColor ?? "var(--main-colour)",
    fontWeight: props.labelWeight ?? 500,
    margin: "0rem",
    textOverflow: "ellipsis",
    whiteSpace: props.wrap ? "normal" : "noWrap",
    overflow: "hidden",
  };

  const primaryIconStyle = () => {
    const baseStyle: CSSProperties = {
      fontWeight: 300,
      margin: "0rem",
      lineHeight: 1,
      color: props.primaryIconColor ?? "var(--main-colour)",
    };

    if (props.primaryIconStyle) {
      return (props.primaryIconStyle = {
        ...props.primaryIconStyle,
        margin: baseStyle.margin,
        lineHeight: baseStyle.lineHeight,
        color: props.primaryIconStyle.color ?? baseStyle.color,
      });
    }

    return baseStyle;
  };

  const secondaryIconStyle = () => {
    const baseStyle: CSSProperties = {
      margin: "0rem",
      lineHeight: 1,
      color: "var(--os-accent)",
      fontWeight: 600,
    };

    if (props.secondaryIconStyle) {
      return {
        ...props.secondaryIconStyle,
        margin: baseStyle.margin,
        lineHeight: baseStyle.lineHeight,
      };
    }

    return baseStyle;
  };

  return (
    <div
      className={`flex gap-4 items-center ${props.width !== undefined ? props.width : "w-auto"
        } ${rightJustify && " flex-row-reverse"} `}
      style={props.style ?? undefined}
      onClick={props.onClick}
    >
      {props.primaryIcon && (
        <FAIcon
          identifier={props.primaryIcon}
          animate={props.animatePrimaryIcon}
          style={primaryIconStyle()}
          size={props.primaryIconSize ?? "2xl"}
          title={props.primaryIconTitle ?? ""}
        />
      )}
      <p style={labelStyle}>
        {props.link ? (
          <a
            className="hover:color-(--os-accent)"
            href={props.link}
            target="_blank"
            rel="noopener noreferrer"
          >
            {props.label}
          </a>
        ) : (
          props.label
        )}
      </p>
      {props.secondaryIcon && props.secondaryIconLink ? (
        <a
          target="_blank"
          rel="noopener noreferrer"
          href={props.secondaryIconLink}
        >
          <FAIcon
            animate={props.animateSecondaryIcon}
            identifier={props.secondaryIcon}
            style={secondaryIconStyle()}
            size={props.secondaryIconSize ?? "2xl"}
            title={props.secondaryIconTitle ?? ""}
          />
        </a>
      ) : (
        props.secondaryIcon && (
          <FAIcon
            identifier={props.secondaryIcon}
            style={secondaryIconStyle()}
            animate={props.animateSecondaryIcon}
            size={props.secondaryIconSize ?? "2xl"}
            title={props.secondaryIconTitle ?? ""}
          />
        )
      )}
    </div>
  );
};

export default OSLabel;
